﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Fluke 1520: (1 year) VER /5320A+VLC,DMM
DATE:                  2016-06-27 14:13:53
AUTHOR:                Fluke
REVISION:              $Revision: 16346 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       97
CONFIGURATION:         Fluke 5320A (VLC)
CONFIGURATION:         Digital Multimeter
=============================================================================
#
#  Procedure Author:
#        DAC, VY
#
#  This procedure contains the following tests whose Test Uncertainty Ratio
#  are less than 4:1.
#
#        LO OHMS MEASUREMENT ACCURACY
#                     -   2 Ohm;        TUR 3.7500
#        MEG OHM MEASUREMENT ACCURACY
#                     -   1 MOhm, 1 kV; TUR 3.6667
#                     -  80 MOhm, 1 kV; TUR 2.8125
#
#  Source:
#        Fluke 1520 MegOhmMeter Calibration Manual
#        PN 1592594, November 2000
#
#        Fluke 1520 Calibration Manual Supplement
#        Supplement Issue: 4, Issue Date: 10/02
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  Additional Equipment Required:
#        None
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
#  NOTE
#   JMPL/LABEL statements in this procedure are used to minimize rotary knob
#   movement and connection chages. However, the order of the tests in the
#   results are determined by statement number.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  IF           0
  1.002  5320         +Voltage = 540 V; Frequency = 60 Hz
  1.003  ENDIF

  1.004  ASK-   R     N              P                            A        V

  1.005  IF           0
  1.006  IEEE         [@DMM]
  1.007  ENDIF

  1.008  IF           NOT(VERSIONCHECK("8.0"))
  1.009  END
  1.010  ENDIF

  1.011  CALL         Sub Initialize /DMM
  1.012  CALL         Sub Display Copyright
  1.013  CALL         Sub High Voltage Safety Warning
  1.014  CALL         Sub Select Failed Test Mode
  1.015  CALL         Sub Select Guardbanding & Ver Method (No NTHROW)
  1.016  CALL         Sub Fluke 1520 Display Test
  1.017  CALL         Sub Fluke 1520 Backlight Test
  1.018  CALL         Sub Fluke 1520 Battery Test
  1.019  CALL         Sub Fluke 1520 (1 year) Discharge Circuit VER /DMM
  1.020  CALL         Sub Fluke 1520 (1 year) Voltage VER /5320+VLC
  1.021  JMPL         MEG_OHM_MEASUREMENT_ACCURACY

  1.022  LABEL        OHMS_MEASUREMENT_ACCURACY
  1.023  CALL         Sub Fluke 1520 (1 year) Ohms VER /5320
  1.024  CALL         Sub Fluke 1520 (1 year) Continuity VER /5320
  1.025  CALL         Sub Fluke 1520 (1 year) Low Ohms VER /5320
  1.026  JMPL         END

  1.027  LABEL        MEG_OHM_MEASUREMENT_ACCURACY
  1.028  CALL         Sub Fluke 1520 (1 year) Megohm VER /5320
  1.029  JMPL         OHMS_MEASUREMENT_ACCURACY

  1.030  LABEL        END
  1.031  DISP         Turn the UUT Rotary Switch to OFF.
  1.032  END
